/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.custinfo;

import com.ibm.hwmca.base.custinfo.AccountBean;
import com.ibm.hwmca.base.custinfo.CustomerInfoConstants;
import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoTasklet;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class AccountTasklet
extends PanelTasklet
implements CustomerInfoConstants {
    private static final String TRACE_MASKT = "XSETACTT";
    private static final String TRACE_MASKF = "XSETACTF";
    private static final String TRACE_MASKD = "XSETACTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "AcctInfoTskl");
    private AccountBean accountBean;

    public AccountTasklet() {
        Trace.trace(TRACE_MASKT, "<> AccountTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.accountBean = new AccountBean();
                this.accountBean.setBeanName("AccountBean");
                CustomerInfoTasklet custInfoTasklet = (CustomerInfoTasklet)this.getParent();
                CustomerInfoData custInfoData = custInfoTasklet.getCustInfoData();
                this.accountBean.setCustomerNumber(custInfoData.getAcctCustNumber());
                this.accountBean.setEnterpriseNumber(custInfoData.getAcctEnterpriseNumber());
                this.accountBean.setSalesBranchOffice(custInfoData.getAcctSalesBranch());
                this.accountBean.setServiceBranchOffice(custInfoData.getAcctServiceBranch());
                this.accountBean.setArea(custInfoData.getAcctArea());
                response.replace("com.ibm.hwmca.base.custinfo.res.CustomerInfoRes", "AccountPanel", this.accountBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("AccountPanel")) {
                    this.serviceAccountPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 2068, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void serviceAccountPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceAccountPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Commit")) {
            AccountBean bean = (AccountBean)request.getData("Bean");
            if (bean != null) {
                CustomerInfoTasklet custInfoTasklet = (CustomerInfoTasklet)this.getParent();
                CustomerInfoData custInfoData = custInfoTasklet.getCustInfoData();
                custInfoData.setAcctCustNumber(bean.getCustomerNumber());
                custInfoData.setAcctEnterpriseNumber(bean.getEnterpriseNumber());
                custInfoData.setAcctSalesBranch(bean.getSalesBranchOffice());
                custInfoData.setAcctServiceBranch(bean.getServiceBranchOffice());
                custInfoData.setAcctArea(bean.getArea());
                Trace.trace(TRACE_MASKF, custInfoData.toString());
            }
            response.noAction();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceAccountPanel()");
    }
}

